//
//  AdResponse.h
//  SDK_Lib
//
//  Created by  on 21/02/22.
//  Copyright © 2022 . All rights reserved.
//

#import <UIKit/UIKit.h>
#import <WebKit/WebKit.h>
#import <CoreTelephony/CTCarrier.h>
#import <CoreTelephony/CTTelephonyNetworkInfo.h>
#include <ifaddrs.h>
#include <arpa/inet.h>
#import <AddressBook/AddressBook.h>
#import <CoreLocation/CoreLocation.h>
#import <AdSupport/ASIdentifierManager.h>
#import <CommonCrypto/CommonDigest.h>
#import <CoreLocation/CoreLocation.h>

@class MPAPIEndpoints;
@class MPPAdMerger;

extern NSData *json_Value;
extern NSString *zoneIdStr;
extern MPAPIEndpoints *defaultBaseHostname;
extern NSString *imp_url_New;
extern NSString *notification_Desc;
extern NSString *notification_Title;
//extern NSArray *updated_geo_adtag;
extern NSDictionary *updated_geo_adtag;
extern NSDictionary *updated_adtag;
extern NSString *adtag_Value;
extern NSString *adType_From;
extern NSString *ad_type;
extern NSString *adTag_Orientation;
extern NSString *wonregionIdentifyAdResponse;
@protocol AdServerCommunicatorDelegate <NSObject>
@end
@protocol NativeAdCommunicatorDelegate <NSObject>
//- (void)communicatorDidReceiveAdConfiguration1:(NSDictionary *)configuration;
@end
//Reward DelegateProtocolMethod
@protocol RewardDelegate <NSObject>
//- (void) Rewarditem:(NSString *) reward rewardValue:(NSString *)rewardvalue;
- (void) rewardVideoDidDisappearForCustomEvent:(NSObject *)customEvent;
- (void) rewardVideoWillDisappearForCustomEvent:(NSObject *)customEvent;
- (void) rewardVideoDidAppearForCustomEvent:(NSObject *)customEvent;
- (void) rewardVideoWillAppearForCustomEvent:(NSObject *)customEvent;
- (void) rewardVideoDidFailToPlayForCustomEvent:(NSObject *)customEvent error:(NSError *)error;
- (void)communicatorDidReceiveAdConfiguration1:(NSDictionary *)configuration;

@end

@protocol AdResponseViewControllerDelegate <UIGestureRecognizerDelegate>
@optional
-(void)handleRequestresponse:(NSString *)loadUrl Responseurl:(NSDictionary *)response;
@end

@interface Ad_Response : UIViewController <UIGestureRecognizerDelegate,WKUIDelegate>

@property (nonatomic, strong) id <AdResponseViewControllerDelegate> AdResponseViewDelegate;
@property (nonatomic, assign) id<RewardDelegate> RewardDelegate;
@property (nonatomic, assign) id<NativeAdCommunicatorDelegate> NativeAdDelegate;

@property(nonatomic, strong) WKWebView *web;

//Basic ad
-(WKWebView *)basic_ad_PassZoneid:(NSString *)zoneid Position:(NSString*)positions  PassCoordinateXAxis:(float)coordinatex PassCoordinateYAxis:(float)coordinatey PassFrameWidth:(float)framewidth PassFrameHeight:(float)frameheight;
//Banner ad
- (void)banner_ad_PassZoneids:(NSString *)zoneid passArrayViews:(NSMutableArray *)arrayView;

//InterstitialImage
//- (WKWebView *)intImg_ad_PassZoneid:(NSString *)zoneid;
- (void)intImg_ad_PassZoneid:(NSString *)zoneid;

//Geofence InterstitialImage
-(void)createInterstitialImage:(NSString *)wonregionIdentify;

//Rewarded ad
-(WKWebView *)reward_ad_PassZoneid:(NSString *)zoneid isRewardDelegate:(NSString *)adrequestvalue;

// native ad
-(WKWebView *)native_ad_PassZoneid:(NSString *)zoneid;

//interstitial video
//- (WKWebView *)PassZoneid:(NSString *)zoneid customTargeting:(NSMutableDictionary *)customparams setKeyword:(NSString *)keyword PassCacheSeconds:(double)cachetime;
- (WKWebView *)intVid_ad_PassZoneid:(NSString *)zoneid;

//genfence ad
-(WKWebView *)geofence_PassZoneid:(NSString *)zoneid;

//default url call methods
-(void)Mediation_tracking:(NSString *)url;
-(NSData*)requestHeaderParams:(NSString *)url header:(NSMutableDictionary *)headerParams;
-(NSString*)encodeURL:(NSString *)stringEncode;
- (void)get_apiCall;

@end

